//	****************************************************************************
//	****************************************************************************
//	****																	****
//	****	PIC18F4320 Registerdefinitionen fr direkte Hardwarezugriffe	****
//	****																	****
//	****************************************************************************
//	****************************************************************************

#byte TBLPTRU=0xFF8
#byte TBLPTRH=0xFF7
#byte TBLPTRL=0xFF6
#byte TABLAT=0xFF5

#byte INTCON=0xFF2
#byte INTCON2=0xFF1
#byte INTCON3=0xFF0


#byte TMR0H=0xFD7
#byte TMR0L=0xFD6
int16 TMR0;
#Locate TMR0=TMR0L
#byte T0CON=0xFD5

#byte OSCCON=0xFD3
#byte HLVDCON=0xFD2
#byte WDTCON=0xFD1
#byte RCON=0xFD0
#byte TMR1H=0xFCF
#byte TMR1L=0xFCE
int16 TMR1;
#locate TMR1=TMR1L
#byte T1CON=0xFCD
#byte TMR2=0xFCC
#byte PR2=0xFCB
#byte T2CON=0xFCA
#byte SSPBUF=0xFC9
#byte SSPADD=0xFC8
#byte SSPSTAT=0xFC7
#byte SSPCON1=0xFC6
#byte SSPCON2=0xFC5
#byte ADRESH=0xFC4
#byte ADRESL=0xFC3
int16 ADRES;
#locate ADRES=ADRESL
#byte ADCON0=0xFC2
#byte ADCON1=0xFC1
#byte ADCON2=0xFC0
#byte CCPR1H=0xFBF
#byte CCPR1L=0xFBE
int16 CCPR1;
#locate CCPR1=CCPR1L
#byte CCP1CON=0xFBD
#byte CCPR2H=0xFBC
#byte CCPR2L=0xFBB
int16 CCPR2;
#locate CCPR2=CCPR2L
#byte CCP2CON=0xFBA

#byte PWM1CON=0xFB7
#byte BAUDCON=0xFB8
#byte ECCP1AS=0xFB6
#byte CVRCON=0xFB5
#byte CMCON=0xFB4
#byte TMR3H=0xFB3
#byte TMR3L=0xFB2
int16 TMR3;
#locate TMR3=TMR3L
#byte T3CON=0xFB1

#byte SPBRGH=0xFB0
#byte SPBRG=0xFAF
#byte RCREG=0xFAE
#byte TXREG=0xFAD
#byte TXSTA=0xFAC
#byte RCSTA=0xFAB

#byte EEADRH=0xFAA
#byte EEADR=0xFA9
#byte EEDATA=0xFA8
#byte EECON2=0xFA7
#byte EECON1=0xFA6

#byte IPR2=0xFA2
#byte PIR2=0xFA1
#byte PIE2=0xFA0
#byte IPR1=0xF9F
#byte PIR1=0xF9E
#byte PIE1=0xF9D

#byte OSCTUNE=0xF9B

#byte TRISE=0xF96
#byte TRISD=0xF95
#byte TRISC=0xF94
#byte TRISB=0xF93
#byte TRISA=0xF92

#byte LATE=0xF8D
#byte LATD=0xF8C
#byte LATC=0xF8B
#byte LATB=0xF8A
#byte LATA=0xF89

#byte PORTE=0xF84
#byte PORTD=0xF83
#byte PORTC=0xF82
#byte PORTB=0xF81
#byte PORTA=0xF80

#bit RBIF=INTCON.0
#bit INT0IF=INTCON.1
#bit TMR0IF=INTCON.2
#bit RBIE=INTCON.3
#bit INT0IE=INTCON.4
#bit TMR0IE=INTCON.5
#bit PEIE=INTCON.6
#bit GIEL=INTCON.6
#bit GIE=INTCON.7
#bit GIEH=INTCON.7

#bit RBIP=INTCON2.0
#bit TMR0IP=INTCON2.2
#bit INTEDG2=INTCON2.4
#bit INTEDG1=INTCON2.5
#bit INTEDG0=INTCON2.6
#bit RBPU=INTCON2.7

#bit INT1IF=INTCON3.0
#bit INT2IF=INTCON3.1
#bit INT1IE=INTCON3.3
#bit INT2IE=INTCON3.4
#bit INT1IP=INTCON3.6
#bit INT2IP=INTCON3.7

#bit PSA=T0CON.3
#bit T0SE=T0CON.4
#bit T0CS=T0CON.5
#bit T08BIT=T0CON.6
#bit TMR0ON=T0CON.7

#bit SCS0=OSCCON.0
#bit SCS1=OSCCON.1
#bit IOFS=OSCCON.2
#bit OSTS=OSCCON.3
#bit IDLEN=OSCCON.7

#bit HLVDEN=HLVDCON.4
#bit IRVST=HLVDCON.5
#bit VDIRMAG=HLVDCON.7

#bit SWDTEN=WDTCON.0

#bit BOR_=RCON.0
#bit POR_=RCON.1
#bit PD=RCON.2
#bit TO=RCON.3
#bit RI_=RCON.4
#bit SBOREN=RCON.6
#bit IPEN=RCON.7

#bit TMR1ON=T1CON.0
#bit TMR1CS=T1CON.1
#bit T1SYNC_=T1CON.2
#bit T1OSCEN=T1CON.3
#bit T1CKPS0=T1CON.4
#bit T1CKPS1=T1CON.5
#bit T1RUN=T1CON.6
#bit RD16=T1CON.7

#bit T2CKPS0=T2CON.0
#bit T2CKPS1=T2CON.1
#bit TMR2ON=T2CON.2

#bit BF=SSPSTAT.0
#bit UA=SSPSTAT.1
#bit RW_=SSPSTAT.2
#bit S=SSPSTAT.3
#bit P=SSPSTAT.4
#bit DA_=SSPSTAT.5
#bit CKE=SSPSTAT.6
#bit SMP=SSPSTAT.7

#bit CKP=SSPCON1.4
#bit SSPEN=SSPCON1.5
#bit SSPOV=SSPCON1.6
#bit WCOL=SSPCON1.7

#bit SEN=SSPCON2.0
#bit RSEN=SSPCON2.1
#bit PEN=SSPCON2.2
#bit RCEN=SSPCON2.3
#bit ACKEN=SSPCON2.4
#bit ACKDT=SSPCON2.5
#bit ACKSTAT=SSPCON2.6
#bit GCEN=SSPCON2.7

#bit ADON=ADCON0.0
#bit GO=ADCON0.1
#bit CHS0=ADCON0.2
#bit CHS1=ADCON0.3
#bit CHS2=ADCON0.4
#bit CHS3=ADCON0.5

#bit VCFG0=ADCON1.4
#bit VCFG1=ADCON1.5

#bit ADCS0=ADCON2.0
#bit ADCS1=ADCON2.1
#bit ADCS2=ADCON2.2
#bit ADFM=ADCON2.7

#bit DC1B0=CCP1CON.4
#bit DC1B1=CCP1CON.5
#bit P1M0=CCP1CON.6
#bit P1M1=CCP1CON.7

#bit DC2B0=CCP2CON.4
#bit DC2B1=CCP2CON.5

#bit ABDEN=BAUDCON.0
#bit WUE=BAUDCON.1
#bit BRG16=BAUDCON.3
#bit SCKP=BAUDCON.4
#bit RCIDL=BAUDCON.6
#bit ABDOVF=BAUDCON.7

#bit PRSEN=PWM1CON.7

#bit PSSBD0=ECCP1AS.0
#bit PSSBD1=ECCP1AS.1
#bit PSSAC0=ECCP1AS.2
#bit PSSAC1=ECCP1AS.3
#bit ECCPASE=ECCP1AS.7

#bit CVRSS=CVRCON.4
#bit CVRR=CVRCON.5
#bit CVROE=CVRCON.6
#bit CVREN=CVRCON.7

#bit CIS=CMCON.3
#bit C1INV=CMCON.4
#bit C2INV=CMCON.5
//#bit C1OUT=CMCON.6
//#bit C2OUT=CMCON.7

#bit TMR3ON=T3CON.0
#bit TMR3CS=T3CON.1
#bit T3SYNC_=T3CON.2
#bit T3CCP1=T3CON.3
#bit T3CKPS0=T3CON.4
#bit T3CKPS1=T3CON.5
#bit T3CCP2=T3CON.6
#bit T3RD16=T3CON.7

#bit TX9D=TXSTA.0
#bit TRMT=TXSTA.1
#bit BRGH=TXSTA.2
#bit SENDB=TXSTA.3
#bit SYNC=TXSTA.4
#bit TXEN=TXSTA.5
#bit TX9=TXSTA.6
#bit CSRC=TXSTA.7

#bit RX9D=RCSTA.0
#bit OERR=RCSTA.1
#bit FERR=RCSTA.2
#bit ADDEN=RCSTA.3
#bit CREN=RCSTA.4
#bit SREN=RCSTA.5
#bit RX9=RCSTA.6
#bit SPEN=RCSTA.7

#bit RD=EECON1.0
#bit WR=EECON1.1
#bit WREN=EECON1.2
#bit WRERR=EECON1.3
#bit FREE=EECON1.4
#bit CFGS=EECON1.6
#bit EEPGD=EECON1.7

#bit CCP2IP=IPR2.0
#bit TMR3IP=IPR2.1
#bit HLVDIP=IPR2.2
#bit BCLIP=IPR2.3
#bit EEIP=IPR2.4
#bit CMIP=IPR2.6
#bit OSCFIP=IPR2.7

#bit CCP2IF=PIR2.0
#bit TMR3IF=PIR2.1
#bit HLVDIF=PIR2.2
#bit BCLIF=PIR2.3
#bit EEIF=PIR2.4
#bit CMIF=PIR2.6
#bit OSCFIF=PIR2.7

#bit CCP2IE=PIE2.0
#bit TMR3IE=PIE2.1
#bit HLVDIE=PIE2.2
#bit BCLIE=PIE2.3
#bit EEIE=PIE2.4
#bit CMIE=PIE2.6
#bit OSCFIE=PIE2.7

#bit TMR1IP=IPR1.0
#bit TMR2IP=IPR1.1
#bit CCP1IP=IPR1.2
#bit SSPIP=IPR1.3
#bit TXIP=IPR1.4
#bit RCIP=IPR1.5
#bit ADIP=IPR1.6
#bit PSPIP=IPR1.7

#bit TMR1IF=PIR1.0
#bit TMR2IF=PIR1.1
#bit CCP1IF=PIR1.2
#bit SSPIF=PIR1.3
#bit TXIF=PIR1.4
#bit RCIF=PIR1.5
#bit ADIF=PIR1.6
#bit PSPIF=PIR1.7

#bit TMR1IE=PIE1.0
#bit TMR2IE=PIE1.1
#bit CCP1IE=PIE1.2
#bit SSPIE=PIE1.3
#bit TXIE=PIE1.4
#bit RCIE=PIE1.5
#bit ADIE=PIE1.6
#bit PSPIE=PIE1.7

#bit PLLEN=OSCTUNE.6
#bit INTSRC=OSCTUNE.7

#bit PSPMODE=TRISE.4
#bit IBOV=TRISE.5
#bit OBF=TRISE.6
#bit IBF=TRISE.7


// The following is an assignment of address values for all of the
// configuration registers for the purpose of table reads
#define _CONFIG1H 0x300001 
#define _CONFIG2L=0x300002 
#define _CONFIG2H=0x300003 
#define _CONFIG3H=0x300005 
#define _CONFIG4L=0x300006 
#define _CONFIG5L=0x300008 
#define _CONFIG5H=0x300009 
#define _CONFIG6L=0x30000A 
#define _CONFIG6H=0x30000B 
#define _CONFIG7L=0x30000C 
#define _CONFIG7H=0x30000D 

//----- CONFIG1H Options --------------------------------------------------
#define _OSC_LP_1H 0xF0FF     // LP oscillator
#define _OSC_XT_1H 0xF1FF     // XT oscillator
#define _OSC_HS_1H 0xF2FF     // HS oscillator
#define _OSC_RC_1H 0xF3FF     // External RC oscillator, CLKO function on RA6
#define _OSC_EC_1H 0xF4FF     // EC oscillator, CLKO function on RA6
#define _OSC_ECIO6_1H 0xF5FF     // EC oscillator, port function on RA6
#define _OSC_HSPLL_1H 0xF6FF     // HS oscillator, PLL enabled (Clock Frequency 4 x FOSC1)
#define _OSC_RCIO6_1H 0xF7FF     // External RC oscillator, port function on RA6
#define _OSC_INTIO67_1H 0xF8FF     // Internal oscillator block, port function on RA6 and RA7
#define _OSC_INTIO7_1H 0xF9FF     // Internal oscillator block, CLKO function on RA6, port function on RA7

#define _FCMEN_OFF_1H 0xBFFF     // Fail-Safe Clock Monitor disabled
#define _FCMEN_ON_1H 0xFFFF     // Fail-Safe Clock Monitor enabled

#define _IESO_OFF_1H 0x7FFF     // Oscillator Switchover mode disabled
#define _IESO_ON_1H 0xFFFF     // Oscillator Switchover mode enabled

//----- CONFIG2L Options --------------------------------------------------
#define _PWRT_ON_2L 0xFFFE     // PWRT enabled
#define _PWRT_OFF_2L 0xFFFF     // PWRT disabled

#define _BOREN_OFF_2L 0xFFF9     // Brown-out Reset disabled in hardware and software
#define _BOREN_ON_2L 0xFFFB     // Brown-out Reset enabled and controlled by software (SBOREN is enabled)
#define _BOREN_NOSLP_2L 0xFFFD     // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled)
#define _BOREN_SBORDIS_2L 0xFFFF     // Brown-out Reset enabled in hardware only (SBOREN is disabled)

#define _BORV_0_2L 0xFFE7     // Maximum setting
#define _BORV_1_2L 0xEFFF     // 
#define _BORV_2_2L 0xFFF7     // 
#define _BORV_3_2L 0xFFFF     // Minimum setting

//----- CONFIG2H Options --------------------------------------------------
#define _WDT_OFF_2H 0xFEFF     // WDT disabled (control is placed on the SWDTEN bit)
#define _WDT_ON_2H 0xFFFF     // WDT enabled

#define _WDTPS_1_2H 0xE1FF     // 1:1
#define _WDTPS_2_2H 0xE3FF     // 1:2
#define _WDTPS_4_2H 0xE5FF     // 1:4
#define _WDTPS_8_2H 0xE7FF     // 1:8
#define _WDTPS_16_2H 0xE9FF     // 1:16
#define _WDTPS_32_2H 0xEBFF     // 1:32
#define _WDTPS_64_2H 0xEDFF     // 1:64
#define _WDTPS_128_2H 0xEFFF     // 1:128
#define _WDTPS_256_2H 0xF1FF     // 1:256
#define _WDTPS_512_2H 0xF3FF     // 1:512
#define _WDTPS_1024_2H 0xF5FF     // 1:1024
#define _WDTPS_2048_2H 0xF7FF     // 1:2048
#define _WDTPS_4096_2H 0xF9FF     // 1:4096
#define _WDTPS_8192_2H 0xFBFF     // 1:8192
#define _WDTPS_16384_2H 0xFDFF     // 1:16384
#define _WDTPS_32768_2H 0xFFFF     // 1:32768

//----- CONFIG3H Options --------------------------------------------------
#define _MCLRE_OFF_3H 0x7FFF     // RE3 input pin enabled// MCLR disabled
#define _MCLRE_ON_3H 0xFFFF     // MCLR pin enabled// RE3 input pin disabled

#define _LPT1OSC_OFF_3H 0xFBFF     // Timer1 configured for higher power operation
#define _LPT1OSC_ON_3H 0xFFFF     // Timer1 configured for low-power operation

#define _PBADEN_OFF_3H 0xFDFF     // PORTB<4:0> pins are configured as digital I/O on Reset
#define _PBADEN_ON_3H 0xFFFF     // PORTB<4:0> pins are configured as analog input channels on Reset

#define _CCP2MX_PORTBE_3H 0xFEFF     // CCP2 input/output is multiplexed with RB3
#define _CCP2MX_PORTC_3H 0xFFFF     // CCP2 input/output is multiplexed with RC1

//----- CONFIG4L Options --------------------------------------------------
#define _STVREN_OFF_4L 0xFFFE     // Stack full/underflow will not cause Reset
#define _STVREN_ON_4L 0xFFFF     // Stack full/underflow will cause Reset

#define _LVP_OFF_4L 0xFFFB     // Single-Supply ICSP disabled
#define _LVP_ON_4L 0xFFFF     // Single-Supply ICSP enabled

#define _XINST_OFF_4L 0xFFBF     // Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
#define _XINST_ON_4L 0xFFFF     // Instruction set extension and Indexed Addressing mode enabled

#define _DEBUG_ON_4L 0xFF7F     // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
#define _DEBUG_OFF_4L 0xFFFF     // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins

//----- CONFIG5L Options --------------------------------------------------
#define _CP0_ON_5L 0xFFFE     // Block 0 (000800-001FFFh) code-protected
#define _CP0_OFF_5L 0xFFFF     // Block 0 (000800-001FFFh) not code-protected

#define _CP1_ON_5L 0xFFFD     // Block 1 (002000-003FFFh) code-protected
#define _CP1_OFF_5L 0xFFFF     // Block 1 (002000-003FFFh) not code-protected

#define _CP2_ON_5L 0xFFFB     // Block 2 (004000-005FFFh) code-protected
#define _CP2_OFF_5L 0xFFFF     // Block 2 (004000-005FFFh) not code-protected

#define _CP3_ON_5L 0xFFF7     // Block 3 (006000-007FFFh) code-protected
#define _CP3_OFF_5L 0xFFFF     // Block 3 (006000-007FFFh) not code-protected

//----- CONFIG5H Options --------------------------------------------------
#define _CPB_ON_5H 0xBFFF     // Boot block (000000-0007FFh) code-protected
#define _CPB_OFF_5H 0xFFFF     // Boot block (000000-0007FFh) not code-protected

#define _CPD_ON_5H 0x7FFF     // Data EEPROM code-protected
#define _CPD_OFF_5H 0xFFFF     // Data EEPROM not code-protected

//----- CONFIG6L Options --------------------------------------------------
#define _WRT0_ON_6L 0xFFFE     // Block 0 (000800-001FFFh) write-protected
#define _WRT0_OFF_6L 0xFFFF     // Block 0 (000800-001FFFh) not write-protected

#define _WRT1_ON_6L 0xFFFD     // Block 1 (002000-003FFFh) write-protected
#define _WRT1_OFF_6L 0xFFFF     // Block 1 (002000-003FFFh) not write-protected

#define _WRT2_ON_6L 0xFFFB     // Block 2 (004000-005FFFh) write-protected
#define _WRT2_OFF_6L 0xFFFF     // Block 2 (004000-005FFFh) not write-protected

#define _WRT3_ON_6L 0xFFF7     // Block 3 (006000-007FFFh) write-protected
#define _WRT3_OFF_6L 0xFFFF     // Block 3 (006000-007FFFh) not write-protected

//----- CONFIG6H Options --------------------------------------------------
#define _WRTB_ON_6H 0xBFFF     // Boot block (000000-0007FFh) write-protected
#define _WRTB_OFF_6H 0xFFFF     // Boot block (000000-0007FFh) not write-protected

#define _WRTC_ON_6H 0xDFFF     // Configuration registers (300000-3000FFh) write-protected
#define _WRTC_OFF_6H 0xFFFF     // Configuration registers (300000-3000FFh) not write-protected

#define _WRTD_ON_6H 0x7FFF     // Data EEPROM write-protected
#define _WRTD_OFF_6H 0xFFFF     // Data EEPROM not write-protected

//----- CONFIG7L Options --------------------------------------------------
#define _EBTR0_ON_7L 0xFFFE     // Block 0 (000800-001FFFh) protected from table reads executed in other blocks
#define _EBTR0_OFF_7L 0xFFFF     // Block 0 (000800-001FFFh) not protected from table reads executed in other blocks

#define _EBTR1_ON_7L 0xFFFD     // Block 1 (002000-003FFFh) protected from table reads executed in other blocks
#define _EBTR1_OFF_7L 0xFFFF     // Block 1 (002000-003FFFh) not protected from table reads executed in other blocks

#define _EBTR2_ON_7L 0xFFFB     // Block 2 (004000-005FFFh) protected from table reads executed in other blocks
#define _EBTR2_OFF_7L 0xFFFF     // Block 2 (004000-005FFFh) not protected from table reads executed in other blocks

#define _EBTR3_ON_7L 0xFFF7     // Block 3 (006000-007FFFh) protected from table reads executed in other blocks
#define _EBTR3_OFF_7L 0xFFFF     // Block 3 (006000-007FFFh) not protected from table reads executed in other blocks

//----- CONFIG7H Options --------------------------------------------------
#define _EBTRB_ON_7H 0xBFFF     // Boot block (000000-0007FFh) protected from table reads executed in other blocks
#define _EBTRB_OFF_7H 0xFFFF     // Boot block (000000-0007FFh) not protected from table reads executed in other blocks

